/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.log.factory;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.log.endpoints.LogEndpoints;
import com.voxeet.log.models.Connect;
import com.voxeet.log.models.Disconnect;
import com.voxeet.log.models.Identify;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LogFactory {
    public static final String ENDPOINT = "https://report.voxeet.com";
    @Nullable
    private LogEndpoints logger;
    public static final LogFactory instance = new LogFactory();
    @NonNull
    private final String sessionId = UUID.randomUUID().toString();

    private LogFactory() {
    }

    public void init(@NonNull LogEndpoints logger) {
        if (null == this.logger) {
            this.logger = logger;
        }
    }

    public void identify(boolean madeFromSdk) {
        if (null == this.logger) {
            return;
        }
        Call<ResponseBody> body = this.logger.identify(new Identify(this.sessionId, madeFromSdk));
        this.consume(body);
    }

    public void connect() {
        if (null == this.logger) {
            return;
        }
        Call<ResponseBody> body = this.logger.connect(new Connect(this.sessionId));
        this.consume(body);
    }

    public void disconnect() {
        if (null == this.logger) {
            return;
        }
        Call<ResponseBody> body = this.logger.disconnect(new Disconnect(this.sessionId));
        this.consume(body);
    }

    private <T> void consume(Call<T> call) {
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
            }

            public void onFailure(Call<T> call, Throwable t) {
            }
        });
    }
}

