/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.utils;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.SoundPool;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import voxeet.com.sdk.utils.AudioType;
import voxeet.com.sdk.utils.Sound;

public class SoundPool {
    private static final String TAG = SoundPool.class.getSimpleName();
    private Context mContext;
    private android.media.SoundPool mShortPlayer = null;
    private HashMap<AudioType, Sound> mSounds = new HashMap();
    private List<Integer> mLooping = new ArrayList<Integer>();

    private SoundPool() {
    }

    public SoundPool(@NonNull Context pContext, int soundMode) {
        this();
        this.mContext = pContext;
        this.mShortPlayer = new android.media.SoundPool(4, soundMode, 0);
        this.mShortPlayer.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(android.media.SoundPool soundPool, int sampleId, int status) {
                Log.d((String)TAG, (String)("onLoadComplete: a new sound is loaded sampleId:=" + sampleId));
                for (AudioType type : SoundPool.this.mSounds.keySet()) {
                    Sound sound = (Sound)SoundPool.this.mSounds.get((Object)type);
                    if (null == sound || sound.getSoundId() != sampleId) continue;
                    Log.d((String)TAG, (String)("onLoadComplete: loaded ? " + sampleId + " " + status));
                    sound.setLoaded(true);
                    if (!sound.isToPlay()) continue;
                    SoundPool.this.play(sound);
                }
            }
        });
    }

    private boolean isLooping(int id) {
        for (Integer integer : this.mLooping) {
            if (null == integer || integer != id) continue;
            return true;
        }
        return false;
    }

    public SoundPool playShortResource(@NonNull AudioType type, @NonNull String assetName) {
        Log.d((String)TAG, (String)("playShortResource: calling " + (Object)((Object)type)));
        Sound sound = this.getOrCreate(type, assetName, true);
        if (null != sound) {
            sound.setLoop(type.isLoop());
            if (this.isLooping(sound.getSoundId())) {
                Log.d((String)TAG, (String)"playShortResource: already playing");
            } else {
                Log.d((String)TAG, (String)("playShortResource: playing resource " + sound.getSoundId()));
                if (sound.isLoaded()) {
                    this.play(sound);
                } else {
                    sound.setPlay(true);
                }
                if (type.isLoop()) {
                    this.mLooping.add(sound.getSoundId());
                }
            }
        }
        return this;
    }

    @Nullable
    private Sound getOrCreate(@NonNull AudioType type, @NonNull String assetName, boolean play) {
        Sound sound = null;
        if (this.mSounds.containsKey((Object)type)) {
            sound = this.mSounds.get((Object)type);
        }
        try {
            if (null == sound) {
                sound = new Sound(assetName);
                Log.d((String)TAG, (String)"playShortResource: not containing, adding it");
                AssetFileDescriptor descriptor = null;
                descriptor = this.mContext.getAssets().openFd(assetName);
                sound.setLoaded(false);
                sound.setPlay(play);
                int sampleId = this.mShortPlayer.load(descriptor, 1);
                sound.setId(sampleId);
                descriptor.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            sound = null;
        }
        if (null != sound) {
            this.mSounds.put(type, sound);
        }
        return sound;
    }

    public SoundPool stop() {
        ArrayList<AudioType> keys_to_remove = new ArrayList<AudioType>();
        Log.d((String)TAG, (String)("stop: " + Arrays.toString(this.mLooping.toArray())));
        for (AudioType key : this.mSounds.keySet()) {
            Sound value = this.mSounds.get((Object)key);
            Log.d((String)TAG, (String)("stop: testing " + value.getName() + " " + value.getSoundId()));
            if (value.isLoaded()) {
                if (!value.isLoop()) continue;
                Log.d((String)TAG, (String)("stop: add to remove later " + value + " " + (Object)((Object)key)));
                value.unload().setLoaded(false).setLoop(false).setPlay(false);
                keys_to_remove.add(key);
                try {
                    this.mShortPlayer.pause(value.getStreamId());
                    this.mShortPlayer.stop(value.getStreamId());
                    this.mShortPlayer.unload(value.getSoundId());
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)"stop: exception...");
                    e.printStackTrace();
                }
                continue;
            }
            value.setPlay(false).setLoop(false).setLoaded(false).unload();
        }
        for (AudioType key : keys_to_remove) {
            Sound sound = this.mSounds.get((Object)key);
            Log.d((String)TAG, (String)("stop: remove " + (Object)((Object)key) + " " + sound.getName() + " " + sound.getSoundId()));
            this.mSounds.remove((Object)key);
        }
        this.mLooping.clear();
        return this;
    }

    public SoundPool stop(@NonNull AudioType key) {
        Log.d((String)TAG, (String)("stop: " + Arrays.toString(this.mLooping.toArray())));
        Sound value = this.mSounds.get((Object)key);
        if (null == value) {
            return this;
        }
        if (value.isLoaded()) {
            Log.d((String)TAG, (String)("stop: testing " + value.getName() + " " + value.getSoundId()));
            if (value.isLoop()) {
                Log.d((String)TAG, (String)("stop: add to remove later " + value + " " + (Object)((Object)key)));
                value.unload().setLoaded(false).setLoop(false).setPlay(false);
                try {
                    this.mShortPlayer.pause(value.getStreamId());
                    this.mShortPlayer.stop(value.getStreamId());
                    this.mShortPlayer.unload(value.getSoundId());
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)"stop: exception...");
                    e.printStackTrace();
                }
            }
        } else {
            value.setPlay(false).setLoop(false).setLoaded(false).unload();
        }
        this.mSounds.remove((Object)key);
        this.mLooping.clear();
        return this;
    }

    public void release() {
        this.mSounds.clear();
        this.mShortPlayer.release();
        this.mShortPlayer = null;
    }

    public boolean setShortResource(@NonNull AudioType type, @NonNull String assetName) {
        Sound sound = this.getOrCreate(type, assetName, false);
        if (null != sound) {
            Log.d((String)TAG, (String)("setShortResource: sound created ? " + sound.getName() + " " + sound.getSoundId()));
            return true;
        }
        Log.d((String)TAG, (String)"setShortResource: error while creating the sound");
        return false;
    }

    private SoundPool play(@NonNull Sound sound) {
        int streamId = this.mShortPlayer.play(sound.getSoundId(), 0.1f, 0.1f, 0, sound.isLoop() ? -1 : 0, 1.0f);
        sound.setStreamId(streamId);
        return this;
    }

    public SoundPool release(@NonNull AudioType type) {
        Sound sound;
        if (this.mSounds.containsKey((Object)type) && null != (sound = this.mSounds.get((Object)type))) {
            this.mShortPlayer.stop(sound.getStreamId());
            this.mShortPlayer.unload(sound.getSoundId());
        }
        return this;
    }
}

