package voxeet.com.sdk.events.success;

import voxeet.com.sdk.events.SuccessEvent;

/**
 * Simple class sent through the app with the result from the
 * subscription on a specific conference id/alias (to be invited
 * when it starts)
 */
public class SubscribeForCallConferenceAnswerEvent extends SuccessEvent {
    private String conferenceId;

    public SubscribeForCallConferenceAnswerEvent(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getSubscribeConference() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }
}
