package com.voxeet.sdk.core.network;

import com.voxeet.android.media.peer.SdpDescription;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.events.success.ReplayConferenceEvent;
import com.voxeet.sdk.events.success.ResumeConference;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.GrandTypeEvent;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.models.CandidatesPush;
import com.voxeet.sdk.models.ConferenceResponse;
import com.voxeet.sdk.models.HistoryConference;
import com.voxeet.sdk.models.SubscribeConference;
import com.voxeet.sdk.models.TokenResponse;

public interface ISdkConferenceRService {

    @POST("v1/conferences/create")
    @Headers({"Content-Type: application/json", "Accept: application/json"})
    Call<ConferenceResponse> createConference(@Body CreateConferenceParams params);

    @GET("v1/conferences/demo")
    Call<ConferenceResponse> createDemo();

    @POST("v1/conferences/{id}/replay")
    @Headers({"Content-Type: application/json", "Accept: application/json"})
    Call<ReplayConferenceEvent> replay(@Path("id") String conferenceId, @Body SdkConferenceReplayBody body);

    @GET("v1/conferences/{id}/recording/stop")
    Call<ResponseBody> stopRecording(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/status")
    Call<GetConferenceStatusEvent> conferenceStatus(@Path("id") String conferenceId);

    @DELETE("/v1/conferences/{id}/subscribe")
    Call<ResponseBody> unSubscribe(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/subscribe")
    Call<SubscribeConference> subscribe(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/history")
    Call<List<HistoryConference>> conferenceHistory(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/recording/start")
    Call<ResponseBody> startRecording(@Path("id") String conferenceId);

    @POST("v1/conferences/{conferenceId}/send")
    Call<ResponseBody> broadcastMessage(@Path("conferenceId") String conferenceId, @Body BroadcastEvent device);

    @POST("v1/conferences/{conferenceId}/join")
    Call<ResumeConference> joinConference(@Path("conferenceId") String conferenceId, @Body JoinParameters device);

    @POST("v1/conferences/{conferenceId}/leave")
    Call<ResponseBody> leaveConference(@Path("conferenceId") String conferenceId);

    @POST("v1/conferences/{conferenceId}/answer/{user_id}")
    Call<ResponseBody> answerConference(@Path("conferenceId") String conferenceId, @Path("user_id") String id, @Body SdpDescription description);

    @POST("v1/conferences/{conferenceId}/invite")
    Call<ResponseBody> invite(@Path("conferenceId") String conferenceId, @Body SdkConferenceInvitation invitation);

    @POST("v1/oauth2/token")
    Call<TokenResponse> getToken(@Header("Authorization") String authorization, @Body GrandTypeEvent grandType);

    @POST("v1/users/logout")
    Call<ResponseBody> logout(@Header("Authorization") String authorization);

    @GET("v1/conferences/{id}/video/{uid}/start")
    Call<StartVideoResponse> startVideo(@Path("id") String conferenceId, @Path("uid") String userId);

    @GET("v1/conferences/{id}/video/{uid}/stop")
    Call<StopVideoResponse> stopVideo(@Path("id") String conferenceId, @Path("uid") String userId);

    @GET("v1/conferences/{id}/sharing/start")
    Call<StartScreenSharingResponse> startScreenShare(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/sharing/stop")
    Call<StopScreenSharingResponse> stopScreenShare(@Path("id") String conferenceId);

    @POST("v1/conferences/{id}/decline")
    Call<ResponseBody> decline(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/call/subscribe")
    Call<ResponseBody> subscribeForCall(@Path("id") String conferenceId);

    @DELETE("v1/conferences/{id}/call/subscribe")
    Call<ResponseBody> unsubscribeFromCall(@Path("id") String conferenceId);

    @POST("v1/conferences/{id}/candidates/{peerId}")
    Call<ResponseBody> candidates(@Path("id") String conferenceId,
                                  @Path("peerId") String peerId,
                                  @Body CandidatesPush body);

    @GET("v1/conferences/{id}/renegociate")
    Call<ResponseBody> renegociate(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/icerestart")
    Call<ResponseBody> iceRestart(@Path("id") String conferenceId);
}
