package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.UnsubscribeFromCallConferenceErrorEvent;
import com.voxeet.sdk.events.success.UnSubscribeFromConferenceAnswerEvent;

public class UnsubscribeForCallStartPromiseable extends AbstractPromiseable<Boolean> {

    public UnsubscribeForCallStartPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                final Call<Response<ResponseBody>> user = getProvider().getUnSubscribeFromCallObservable(getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<Response<ResponseBody>>() {
                    @Override
                    public void onSuccess(@NonNull Response<ResponseBody> object, @NonNull Response<Response<ResponseBody>> response) {
                        log("You are no longer subscribed to this mConference's start");

                        getEventBus().post(new UnSubscribeFromConferenceAnswerEvent(getInformation().getConference().getConferenceId()));
                        solver.resolve(true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<Response<ResponseBody>> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Failed to unsubscribe from this mConference's start");

                        getEventBus().post(new UnsubscribeFromCallConferenceErrorEvent(getInformation().getConference().getConferenceId(), getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}
