/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetDispatcher;
import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.network.websocket.ConnectListener;
import com.voxeet.sdk.core.network.websocket.SocketListener;
import com.voxeet.sdk.core.network.websocket.WebSocketProxy;
import com.voxeet.sdk.core.services.authenticate.WebSocketState;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import com.voxeet.sdk.utils.Twig;
import java.util.ArrayList;
import java.util.List;
import okhttp3.WebSocket;

public class VoxeetWebSocket {
    private static final String TAG = VoxeetWebSocket.class.getSimpleName();
    private AbstractVoxeetEnvironmentHolder environment_holder;
    private Twig twig;
    static final String SOCKET_ERROR = "SOCKET_ERROR";
    static final String SOCKET_MESSAGE = "SOCKET_TEXT";
    static final String SOCKET_CONNECTED = "SOCKET_CONNECTED";
    static final String SOCKET_DISCONNECTED = "SOCKET_DISCONNECTED";
    static final String SOCKET_STATE_CHANGE = "SOCKET_STATE_CHANGE";
    private Context context;
    private String socketUrl;
    private WebSocketProxy mWebSocketProxy;
    private List<ConnectListener> mConnectListeners;
    private ConnectListener mConnectListener;
    private SocketListener listener = new SocketListener(){

        @Override
        public void onConnect(WebSocket webSocket) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_CONNECTED, "Connected");
        }

        @Override
        public void onTextMessage(String message) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_MESSAGE, message);
        }

        @Override
        public void onError(HttpException exception) {
            exception.printStackTrace();
            if (null != exception.getResponse()) {
                try {
                    Log.d((String)TAG, (String)("onError: http exception for socket (message) " + exception.getResponse().message()));
                    Log.d((String)TAG, (String)("onError: http exception for socket (body) " + exception.getResponse().body().toString()));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_ERROR, "Error " + exception.getMessage());
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onStateChanged(WebSocketState newState) {
            Log.d((String)TAG, (String)("onStateChanged: newState:=" + (Object)((Object)newState)));
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_STATE_CHANGE, newState.name());
        }

        @Override
        public void onDisconnected() {
            VoxeetWebSocket.this.twig.e("Websocket disconnect by server", new Object[0]);
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_DISCONNECTED, "on Disconnected by server: ");
        }
    };

    public VoxeetWebSocket(Context context, VoxeetSdkTemplate sdk, @NonNull String socketUrl) {
        this.environment_holder = sdk.getVoxeetEnvironmentHolder();
        this.context = context;
        this.twig = sdk.getTwig();
        this.socketUrl = socketUrl;
        this.mConnectListeners = new ArrayList<ConnectListener>();
        this.mConnectListener = new ConnectListener(){

            @Override
            public void onConnect(WebSocket websocket) {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onConnect(websocket);
                }
            }

            @Override
            public void onConnectError(HttpException e) {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onConnectError(e);
                }
            }

            @Override
            public void onNoNetwork() {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onNoNetwork();
                }
            }
        };
    }

    public void connect(@NonNull VoxeetHttp provider) {
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.removeListeners();
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
        }
        this.createProxy();
        this.mWebSocketProxy.connect(provider, this.mConnectListener);
    }

    private void clear() {
        VoxeetDispatcher.dispatch(SOCKET_STATE_CHANGE, WebSocketState.CLOSED.name());
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
            this.mWebSocketProxy.removeListener(this.listener);
            this.mWebSocketProxy.removeListeners();
        }
        this.mWebSocketProxy = null;
    }

    private void createProxy() {
        this.mWebSocketProxy = new WebSocketProxy(this.context, this.socketUrl, this.environment_holder.getVersionName());
        this.mWebSocketProxy.addListener(this.listener);
    }

    public void close(boolean set_disconnect) {
        this.clear();
    }

    public boolean isOpen() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }

    private boolean sendPing() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.sendPing();
    }

    public boolean isInit() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }
}

