package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import com.voxeet.sdk.models.RecordingStatus;
import com.voxeet.sdk.models.impl.DefaultConference;
import com.voxeet.sdk.models.impl.DefaultConferenceInfos;
import com.voxeet.sdk.models.impl.DefaultConferenceUser;
import com.voxeet.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.USER_INVITED)
public class UserInvited extends Event {

    @JsonProperty("conference")
    private DefaultConferenceInfos conferenceInfos;

    private List<DefaultUserProfile> participants;

    public List<DefaultUserProfile> getParticipants() {
        return participants;
    }

    public void setParticipants(List<DefaultUserProfile> participants) {
        this.participants = participants;
    }

    public DefaultConference getConference() {
        DefaultConference conference = new DefaultConference();
        conference.setConferenceInfos(conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(conferenceInfos.getConferenceType());
        conference.setMeetingId(conferenceInfos.getMeetingId());
        conference.setConferenceId(conferenceInfos.getConferenceId());
        conference.setDescription(conferenceInfos.getDescription());
        conference.setLocation(conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);

        for (DefaultUserProfile profile : participants) {
            conference.getConferenceUsers().add(new DefaultConferenceUser(profile));
        }

        return conference;
    }

    public DefaultConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return EventNames.USER_INVITED;
    }
}
