package com.voxeet.sdk.events.error;

import android.Manifest;

/**
 * Event triggered to warn a missing permission
 * <p>
 * Those permissions are managed for now :
 * - Camera
 */

public class PermissionRefusedEvent {
    public static final int RESULT_CAMERA = 0x0001;
    public static final int RESULT_MICROPHONE = 0x0005;
    public static final int RESULT_MANDATORY = RESULT_CAMERA | RESULT_MICROPHONE;
    private Permission mPermission;

    public PermissionRefusedEvent() {

    }

    public PermissionRefusedEvent(Permission permission) {
        this();

        mPermission = permission;
    }

    public Permission getPermission() {
        return mPermission;
    }

    public enum Permission {
        CAMERA(new String[]{Manifest.permission.CAMERA},
                PermissionRefusedEvent.RESULT_CAMERA),
        MICROPHONE(new String[]{Manifest.permission.RECORD_AUDIO},
                PermissionRefusedEvent.RESULT_MICROPHONE);

        private final int requestCode;
        private final String[] permissions;

        Permission(String[] permissions, int requestCode) {
            this.permissions = permissions;
            this.requestCode = requestCode;
        }

        public int getRequestCode() {
            return requestCode;
        }

        public String[] getPermissions() {
            return permissions;
        }
    }
}
