package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.GetConferenceHistoryErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.success.GetConferenceHistoryEvent;
import com.voxeet.sdk.models.HistoryConference;

public class GetConferenceHistoryPromiseable extends AbstractPromiseable<GetConferenceHistoryEvent> {

    public GetConferenceHistoryPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<GetConferenceHistoryEvent> createPromise() {
        return new Promise<>(new PromiseSolver<GetConferenceHistoryEvent>() {
            @Override
            public void onCall(@NonNull final Solver<GetConferenceHistoryEvent> solver) {
                final Call<List<HistoryConference>> user = getProvider().getConferenceHistoryObservable(getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<List<HistoryConference>>() {
                    @Override
                    public void onSuccess(@NonNull List<HistoryConference> object, @NonNull Response<List<HistoryConference>> response) {
                        log("Dispatching mConference history response");

                        GetConferenceHistoryEvent event = new GetConferenceHistoryEvent(object);
                        getEventBus().post(event);
                        solver.resolve(event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<List<HistoryConference>> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Error while retrieving mConference history");

                        getEventBus().post(new GetConferenceHistoryErrorEvent(getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}
