/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.audio;

import java.net.InetSocketAddress;

public class AudioSettings {
    private String mStunHost;
    private int mStunPort;
    private boolean isNoiseSuppressionEnabled;
    private boolean isAutomaticGainControlEnabled;
    private boolean isEchoControlEnabled;
    private boolean isTypingDetectionEnabled;
    private int delayMs;

    public AudioSettings(String stunHost, int stunPort) {
        this(stunHost, stunPort, true, true, true, false);
        this.delayMs = 0;
    }

    public AudioSettings(String stunHost, int stunPort, boolean ns, boolean ag, boolean ec, boolean td) {
        this.mStunHost = stunHost;
        this.mStunPort = stunPort;
        this.isNoiseSuppressionEnabled = ns;
        this.isAutomaticGainControlEnabled = ag;
        this.isEchoControlEnabled = ec;
        this.isTypingDetectionEnabled = td;
    }

    public String stunHost() {
        InetSocketAddress address = new InetSocketAddress(this.mStunHost, this.mStunPort);
        return address.toString();
    }

    public boolean noiseSuppressionEnabled() {
        return this.isNoiseSuppressionEnabled;
    }

    public void setNoiseSuppressionEnabled(boolean enabled) {
        this.isNoiseSuppressionEnabled = enabled;
    }

    public boolean automaticGainControlEnabled() {
        return this.isAutomaticGainControlEnabled;
    }

    public void setAutomaticGainControlEnabled(boolean enabled) {
        this.isAutomaticGainControlEnabled = enabled;
    }

    public boolean echoControlEnabled() {
        return this.isEchoControlEnabled;
    }

    public void setEchoControlEnabled(boolean enabled) {
        this.isEchoControlEnabled = enabled;
    }

    public boolean typingDetectionEnabled() {
        return this.isTypingDetectionEnabled;
    }

    public void setTypingDetectionEnabled(boolean enabled) {
        this.isTypingDetectionEnabled = enabled;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public void setDelayMs(int delayMs) {
        this.delayMs = delayMs;
    }
}

