package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import com.voxeet.sdk.models.ConferenceUserStatus;
import com.voxeet.sdk.models.abs.ConferenceUser;

public class ConferenceUtils {

    private ConferenceUtils() {

    }



    @Nullable
    public static ConferenceUser findUserById(@Nullable final String userId,
                                                     @Nullable List<ConferenceUser> users) {
        if(null != users) {
            for (ConferenceUser user : users) {
                if(null != userId && userId.equalsIgnoreCase(user.getUserId())) {
                    return user;
                }
            }
        }
        return null;
    }

    @NonNull
    public static List<ConferenceUser> findUsersMatching(@Nullable String currentUserOrEmpty, @Nullable List<ConferenceUser> merged_list) {
        List<ConferenceUser> list = new ArrayList<>();
        if(null != currentUserOrEmpty && null != merged_list) {
            for (ConferenceUser user : merged_list) {
                if(null != user && currentUserOrEmpty.equalsIgnoreCase(user.getUserId())) {
                    list.add(user);
                }
            }
        }
        return list;
    }

    public static List<ConferenceUser> getUserInState(List<ConferenceUser> conferenceUsers, ConferenceUserStatus status) {
        List<ConferenceUser> users = new ArrayList<>();
        for (ConferenceUser user : conferenceUsers) {
            if(null != user && status.equals(user.getConferenceStatus())) {
                users.add(user);
            }
        }

        return users;
    }
}
