package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import com.voxeet.sdk.models.impl.DefaultConferenceInfos;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_CONFERENCE_CREATED)
public class OwnConferenceCreated extends Event {

    @JsonProperty("userId")
    private String userId;

    @JsonProperty("conferenceInfo")
    private DefaultConferenceInfos conferenceInfos;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DefaultConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfo(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return EventNames.OWN_CONFERENCE_CREATED;
    }
}
