package com.voxeet.sdk.core.abs;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;

import com.voxeet.android.media.MediaSDK;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import eu.codlab.simplepromise.Promise;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.models.ConferenceUserStatus;
import com.voxeet.sdk.models.OfferCandidate;
import com.voxeet.sdk.models.OfferDescription;
import com.voxeet.sdk.models.abs.ConferenceUser;

public abstract class AbstractPromiseable<PROMISE_RETURN_TYPE> {
    private final AbstractConferenceSdkObservableProvider provider;
    private final ConferenceInformation information;
    private final EventBus eventBus;
    @NonNull
    private MediaService mediaService;
    @NonNull
    private AbstractConferenceSdkService parent;

    protected AbstractPromiseable(@NonNull AbstractConferenceSdkService parent,
                                  @NonNull MediaService mediaService,
                                  @NonNull AbstractConferenceSdkObservableProvider provider,
                                  @Nullable ConferenceInformation information,
                                  @NonNull EventBus eventBus) {

        this.parent = parent;
        this.mediaService = mediaService;
        this.provider = provider;
        this.information = information;
        this.eventBus = eventBus;
    }

    @NonNull
    protected AbstractConferenceSdkService getParent() {
        return parent;
    }

    @NonNull
    protected MediaService getMediaService() {
        return mediaService;
    }

    @NonNull
    protected AbstractConferenceSdkObservableProvider getProvider() {
        return provider;
    }

    @Nullable
    protected ConferenceInformation getInformation() {
        return information;
    }

    @NonNull
    protected EventBus getEventBus() {
        return eventBus;
    }

    protected boolean isInConference() {
        return getParent().isInConference();
    }

    protected boolean hasMedia() {
        return getMediaService().hasMedia();
    }

    @NonNull
    protected MediaSDK getMedia() {
        return getMediaService().getMedia();
    }

    @NonNull
    public abstract Promise<PROMISE_RETURN_TYPE> createPromise();

    protected void log(@NonNull String log) {
        if (!TextUtils.isEmpty(log)) {
            Log.d(getClass().getSimpleName(), log);
        }
    }

    protected void setIsInConference(boolean status) {
        getParent().setIsInConference(status);
    }

    protected Promise<Boolean> createVideoAnswer(final String userId,
                                                 final OfferDescription offerDescription,
                                                 final List<OfferCandidate> offerCandidates) {
        return getParent().createVideoAnswer(userId,
                offerDescription,
                offerCandidates);
    }

    protected boolean isSDK() {
        return getParent().isSDK();
    }

    protected ConferenceUser updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        return getParent().updateConferenceParticipants(userId, status);
    }

    protected void closeMedia() {
        getParent().closeMedia();
    }

    protected void removeTimeoutCallbacks() {
        getParent().removeTimeoutCallbacks();
    }

    protected void sendTimeoutCallbacks() {
        getParent().sendTimeoutCallbacks();
    }

    protected VoxeetSdkTemplate getVoxeetSDK() {
        return getParent().getVoxeetSDK();
    }

    @NonNull
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        return getParent().createOrSetConferenceWithParams(conferenceId, conferenceAlias);
    }

    protected ConferenceInformation getConferenceInformation(@Nullable String conferenceId) {
        return getParent().getConferenceInformation(conferenceId);
    }

    protected void joinLock() {
        getParent().joinLock();
    }

    protected void joinUnlock() {
        getParent().joinUnlock();
    }

    protected Promise<Boolean> joinConference(@NonNull ConferenceInformation conference) {
        return getParent().joinConferenceInternalPackage(conference);
    }

    protected void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        getParent().setCurrentConferenceIfNotInPreviousConference(conference);
    }
}
