package com.voxeet.sdk.audio;

public class PendingUserState implements AudioUserState {

    private AudioPosition mPosition;

    public PendingUserState() {
        mPosition = DEFAULT_POSITION;
    }

    @Override
    public void updatePosition(double angle, double distance) {
        mPosition = new AudioPosition(angle, distance);
    }

    @Override
    public void updateGain(float gain) {
        mPosition = new AudioPosition(mPosition.angle(), mPosition.distance(), gain);
    }

    @Override
    public AudioPosition position() {
        return mPosition;
    }

}
