package com.voxeet.sdk.audio;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;

import java.util.ArrayList;
import java.util.List;

public class MessagingEnvironment {

    public static class Builder {
        private Context _context;
        private MessagingEnvironment _messaging_environment;

        private Builder() {
            _messaging_environment = new MessagingEnvironment();
        }

        public Builder(@NonNull Context context) {
            this();

            _context = context;
        }

        public Builder setServerHost(@StringRes int host) {
            _messaging_environment.addServerHost(_context.getString(host));

            return this;
        }

        public Builder setServerPort(@StringRes int port) {
            int server_port = Integer.parseInt(_context.getString(port));
            _messaging_environment.setServerPort(server_port);

            return this;
        }

        public Builder setStunHost(@StringRes int stun_host) {
            _messaging_environment.setStunHost(_context.getString(stun_host));

            return this;
        }

        public Builder setStunPort(@StringRes int stun_port) {
            int stun_server_port = Integer.parseInt(_context.getString(stun_port));
            _messaging_environment.setStunPort(stun_server_port);

            return this;
        }

        public MessagingEnvironment build() {
            return _messaging_environment;
        }
    }

    static final int DEFAILT_CONNECTION_TIMEOUT = 15000;
    static final int DEFAULT_KEEP_ALIVE_INTERVAL = 30000;
    static final int DEFAULT_RECONNECTION_DELAY = 1500;
    static final int DEFAULT_RECONNECTION_LIMIT = 60000;
    static final int DEFAULT_MAX_RECONNECTION_ATTEMPTS = 5;

    private List<String> mServerHosts;
    private int mServerPort;

    private String mStunHost;
    private int mStunPort;

    private int mConnectionTimeout;
    private int mSearchPageSize;
    private int mKeepAliveInterval;

    /**
     * Initial timeout to start a reconnect
     */
    private int mReconnectionDelay;

    /**
     * The max reconnection delay in milliseconds
     */
    private int mReconnectionLimit;

    /**
     * How many times should connection attempt to reconnect with the server after a a dropped connection
     */
    private int mMaxReconnectionAttempts;

    private MessagingEnvironment() {
        mConnectionTimeout = DEFAILT_CONNECTION_TIMEOUT;
        mKeepAliveInterval = DEFAULT_KEEP_ALIVE_INTERVAL;
        mReconnectionDelay = DEFAULT_RECONNECTION_DELAY;
        mReconnectionLimit = DEFAULT_RECONNECTION_LIMIT;
        mMaxReconnectionAttempts = DEFAULT_MAX_RECONNECTION_ATTEMPTS;

        mServerHosts = new ArrayList<String>();
    }

    public int getReconnectionDelay() {
        return mReconnectionDelay;
    }

    public int getReconnectionLimit() {
        return mReconnectionLimit;
    }

    public int getMaxReconnectionAttempts() {
        return mMaxReconnectionAttempts;
    }

    public List<String> getServerHosts() {
        return mServerHosts;
    }

    public void addServerHost(String address) {
        mServerHosts.add(address);
    }

    public int getServerPort() {
        return mServerPort;
    }

    public void setServerPort(int serverPort) {
        mServerPort = serverPort;
    }

    public void setStunHost(String stunHost) {
        mStunHost = stunHost;
    }

    public String getStunHost() {
        return mStunHost;
    }

    public void setStunPort(int stunPort) {
        mStunPort = stunPort;
    }

    public int getStunPort() {
        return mStunPort;
    }

    public int getConnectionTimeout() {
        return mConnectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        mConnectionTimeout = connectionTimeout;
    }

    public int getSearchPageSize() {
        return mSearchPageSize;
    }

    public void setSearchPageSize(int searchPageSize) {
        mSearchPageSize = searchPageSize;
    }

    public int getKeepAliveInterval() {
        return mKeepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        mKeepAliveInterval = keepAliveInterval;
    }
}
