package com.voxeet.sdk.audio;

import java.net.InetSocketAddress;

public class AudioSettings {
    private String mStunHost;
    private int mStunPort;

    private boolean isNoiseSuppressionEnabled;
    private boolean isAutomaticGainControlEnabled;
    private boolean isEchoControlEnabled;
    private boolean isTypingDetectionEnabled;

    private int delayMs;

    public AudioSettings(String stunHost, int stunPort) {
        this(stunHost, stunPort, true, true, true, false);

        delayMs = 0;
    }

    public AudioSettings(String stunHost, int stunPort, boolean ns, boolean ag, boolean ec, boolean td) {
        mStunHost = stunHost;
        mStunPort = stunPort;
        this.isNoiseSuppressionEnabled = ns;
        this.isAutomaticGainControlEnabled = ag;
        this.isEchoControlEnabled = ec;
        this.isTypingDetectionEnabled = td;
    }

    public String stunHost() {
        InetSocketAddress address = new InetSocketAddress(mStunHost, mStunPort);
        return address.toString();
    }

    public boolean noiseSuppressionEnabled() {
        return isNoiseSuppressionEnabled;
    }

    public void setNoiseSuppressionEnabled(boolean enabled) {
        isNoiseSuppressionEnabled = enabled;
    }

    public boolean automaticGainControlEnabled() {
        return isAutomaticGainControlEnabled;
    }

    public void setAutomaticGainControlEnabled(boolean enabled) {
        isAutomaticGainControlEnabled = enabled;
    }

    public boolean echoControlEnabled() {
        return isEchoControlEnabled;
    }

    public void setEchoControlEnabled(boolean enabled) {
        isEchoControlEnabled = enabled;
    }

    public boolean typingDetectionEnabled() {
        return isTypingDetectionEnabled;
    }

    public void setTypingDetectionEnabled(boolean enabled) {
        isTypingDetectionEnabled = enabled;
    }

    public int delayMs() {
        return delayMs;
    }

    public void setDelayMs(int delayMs) {
        this.delayMs = delayMs;
    }
}
