/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.stats.LocalStats;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.core.services.localstats.LocalStatsHandler;
import voxeet.com.sdk.core.services.localstats.LocalStatsUserInfo;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class LocalStatsService
extends AbstractVoxeetService
implements Runnable {
    public static final int NEXT_LOOP_FETCH_MS = 500;
    private ReentrantLock mLock;
    private VoxeetSdkTemplate mInstance;
    private LocalStatsHandler mHandler = null;
    private HashMap<String, HashMap<String, LocalStatsUserInfo>> mConferencesHolder = new HashMap();

    public LocalStatsService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mLock = new ReentrantLock();
        this.mInstance = instance;
    }

    @Nullable
    public LocalStats getLocalStats(@Nullable String peer) {
        if (null == peer) {
            return null;
        }
        MediaSDK media = this.mInstance.getMediaService().getMedia();
        if (null != media) {
            return media.getLocalStats(peer);
        }
        return null;
    }

    public boolean startAutoFetch() {
        if (null == this.mHandler) {
            this.mHandler = new LocalStatsHandler(this, 500L);
            this.mHandler.startAutoFetch();
            return true;
        }
        return false;
    }

    public boolean stopAutoFetch() {
        if (null != this.mHandler) {
            this.mHandler.stopAutoFetch();
            this.mHandler = null;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        DefaultConference conference = ((AbstractConferenceSdkService)this.mInstance.getConferenceService()).getConference();
        if (null != conference) {
            List<DefaultConferenceUser> users = conference.getConferenceUsers();
            for (int i = 0; i < users.size(); ++i) {
                DefaultConferenceUser user = users.get(i);
                LocalStats stat = this.getLocalStats(user.getUserId());
                this.getUserInfo(conference.getConferenceId(), user.getUserId()).addFromLocalStats(stat);
            }
        }
    }

    @NonNull
    private HashMap<String, LocalStatsUserInfo> getUserStatsHolder(@NonNull String conferenceId) {
        HashMap<String, LocalStatsUserInfo> holder = this.mConferencesHolder.get(conferenceId);
        if (null == holder) {
            holder = new HashMap();
            this.mConferencesHolder.put(conferenceId, holder);
        }
        return holder;
    }

    public LocalStatsUserInfo getUserInfo(@NonNull String conferenceId, @NonNull String userId) {
        HashMap<String, LocalStatsUserInfo> holder = this.getUserStatsHolder(conferenceId);
        LocalStatsUserInfo info = holder.get(userId);
        if (null == info) {
            info = new LocalStatsUserInfo(userId);
            holder.put(userId, info);
        }
        return info;
    }
}

