/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.network;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;
import voxeet.com.sdk.events.success.GetUserProfileSuccessEvent;
import voxeet.com.sdk.events.success.LoginSuccessResponseEvent;
import voxeet.com.sdk.events.success.OwnProfileSuccessEvent;
import voxeet.com.sdk.json.EmailEvent;
import voxeet.com.sdk.json.LoginEvent;
import voxeet.com.sdk.json.ResendActivationEvent;
import voxeet.com.sdk.json.ResetPasswordEvent;
import voxeet.com.sdk.json.SignUpEvent;
import voxeet.com.sdk.json.SocialLoginEvent;
import voxeet.com.sdk.json.UpdatePasswordEvent;
import voxeet.com.sdk.json.UpdatePresenceEvent;
import voxeet.com.sdk.json.UpdateProfileEvent;

public interface IUserRService {
    @POST(value="users/login")
    public Call<LoginSuccessResponseEvent> login(@Body LoginEvent var1);

    @POST(value="mobile/loginValidated")
    public Call<LoginSuccessResponseEvent> socialLogin(@Body SocialLoginEvent var1);

    @POST(value="users/logout")
    public Call<ResponseBody> logout();

    @POST(value="users/resetPassword")
    public Call<ResponseBody> resetPassword(@Body ResetPasswordEvent var1);

    @POST(value="users/create")
    public Call<ResponseBody> signup(@Body SignUpEvent var1);

    @PUT(value="users/me")
    public Call<ResponseBody> updateProfile(@Body UpdateProfileEvent var1);

    @PUT(value="users/me/updatePresence")
    public Call<ResponseBody> updatePresence(@Body UpdatePresenceEvent var1);

    @GET(value="users/me")
    @Headers(value={"Content-Type: application/json"})
    public Call<OwnProfileSuccessEvent> getOwnProfile();

    @GET(value="users/me/getUploadToken")
    @Headers(value={"Content-Type: application/json"})
    public Call<GetTokenUploadSuccessEvent> getUploadToken();

    @GET(value="users/{userId}")
    public Call<GetUserProfileSuccessEvent> getUserProfile(@Path(value="userId") String var1);

    @POST(value="users/resendActivation")
    public Call<ResponseBody> resendActivation(@Body ResendActivationEvent var1);

    @POST(value="users/resendValidation")
    public Call<ResponseBody> resendValidation(@Body ResendActivationEvent var1);

    @PUT(value="users/me/addEmail")
    public Call<ResponseBody> addEmail(@Body EmailEvent var1);

    @PUT(value="users/me/removeEmail")
    public Call<ResponseBody> removeEmail(@Body EmailEvent var1);

    @PUT(value="users/me/setDefaultEmail")
    public Call<ResponseBody> setDefaultEmail(@Body EmailEvent var1);

    @PUT(value="/users/me/updatePassword")
    public Call<ResponseBody> updatePassword(@Body UpdatePasswordEvent var1);
}

