/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.promises.NotInConferenceException;
import voxeet.com.sdk.events.success.SendBroadcastResultEvent;
import voxeet.com.sdk.json.BroadcastEvent;

public class SendBroadcastMessagePromise
extends AbstractPromiseable<Boolean> {
    private final String message;
    private final String conferenceId;

    public SendBroadcastMessagePromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId, @NonNull String message) {
        super(parent, mediaService, provider, information, eventBus);
        this.conferenceId = conferenceId;
        this.message = message;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    if (null == SendBroadcastMessagePromise.this.conferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
                Call<ResponseBody> user = SendBroadcastMessagePromise.this.getProvider().broadcastMessage(SendBroadcastMessagePromise.this.conferenceId, new BroadcastEvent(SendBroadcastMessagePromise.this.message));
                HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        SendBroadcastMessagePromise.this.log("The broadcast message has been sent");
                        SendBroadcastMessagePromise.this.getEventBus().post((Object)new SendBroadcastResultEvent(response.code() == 200));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        SendBroadcastMessagePromise.this.log("The broadcast message has not been sent");
                        SendBroadcastMessagePromise.this.getEventBus().post((Object)new SendBroadcastResultEvent(SendBroadcastMessagePromise.this.getParent().handleError(e), false));
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }
}

