/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.EglBaseRefreshEvent;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.android.media.crypto.AbstractNativeMediaCryptoCallback;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.PendingPeerOperation;
import com.voxeet.android.media.peer.SdpCandidates;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.Type;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;

public class MediaSDK
extends MediaEngine {
    public static final String TAG = MediaSDK.class.getSimpleName();
    private static long DescriptionTimeout = 5000L;
    private static final Object mOperationLock = new Object();
    private static final Object mCandidateLock = new Object();
    @NonNull
    private SdpCandidates mPeerCandidates = new SdpCandidates();
    @NonNull
    private List<PendingPeerOperation> mPeerOperations = new ArrayList<PendingPeerOperation>();

    public static void setDescriptionTimeout(long descriptionTimeout) {
        DescriptionTimeout = descriptionTimeout;
    }

    public static Context context() {
        return MediaEngine.Context;
    }

    public MediaSDK(@NonNull Context context, @NonNull String peer, @NonNull MediaEngine.StreamListener listener, @NonNull CameraVideoCapturer.CameraEventsHandler cameraListener, boolean startWithVideo, boolean microphone, @Nullable AbstractNativeMediaCryptoCallback delegate) throws MediaEngineException {
        super(context, peer, listener, cameraListener, startWithVideo, microphone, delegate);
    }

    protected void onEglBaseRecreated(@NonNull EglBase base) {
        EventBus.getDefault().post((Object)new EglBaseRefreshEvent(base));
    }

    public void createAnswerForPeer(@NonNull String peer, long ssrc, @NonNull SdpDescription offer, @NonNull List<SdpCandidate> offerCandidates, boolean isMaster, @NonNull PendingPeerCallback listener) throws MediaEngineException {
        this.createConnection(peer, isMaster);
        if (!this.setPeerDescription(peer, ssrc, offer.getType(), offer.getSdp())) {
            throw new MediaEngineException(String.format("Unable set remote SDP for Peer: %s", peer));
        }
        for (SdpCandidate c : offerCandidates) {
            this.setPeerCandidate(peer, c.getSdpMid(), c.getSdpMLineIndex(), c.getSdp());
        }
        this.WaitForSdpMessage(peer, Type.ANSWER, listener);
        if (!this.createAnswer(peer)) {
            throw new MediaEngineException(String.format("Unable to create answer for Peer: %s", peer));
        }
    }

    public void addPeerFromAnswer(@NonNull String peer, long ssrc, @NonNull SdpDescription answer, @NonNull List<SdpCandidate> candidates) throws MediaEngineException {
        if (!this.setPeerDescription(peer, ssrc, answer.getType(), answer.getSdp())) {
            throw new MediaEngineException(String.format("Unable set remote SDP for Peer: %s", peer));
        }
        for (SdpCandidate candidate : candidates) {
            this.setPeerCandidate(peer, candidate.getSdpMid(), candidate.getSdpMLineIndex(), candidate.getSdp());
        }
    }

    public void onSessionCreated(@NonNull String peer, @NonNull String type, @NonNull String sdp) {
        Log.d((String)TAG, (String)String.format("Session description received for peer: %s with type: %s and SDP: %s", peer, type, sdp));
        Type operationType = Type.fromString(type);
        if (null != operationType) {
            this.unlockPeerOperation(operationType, peer, new SdpDescription(type, sdp));
        } else {
            Log.w((String)TAG, (String)String.format("Session description received from an unknown type: %s", type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIceCandidateDiscovered(@NonNull String peer, @NonNull SdpCandidate[] candidates) {
        Log.d((String)TAG, (String)String.format("ICE candidate discovered for peer: %s with id", peer));
        this.mStreamListener.onIceCandidateDiscovered(peer, candidates);
        Object object = mCandidateLock;
        synchronized (object) {
            for (SdpCandidate candidate : candidates) {
                this.mPeerCandidates.add(peer, candidate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIceGatheringComplete(@NonNull String peer) {
        Log.d((String)TAG, (String)String.format("ICE candidate gathering complete for peer: %s", peer));
        List<SdpCandidate> candidates = null;
        SdpDescription description = null;
        Object object = mCandidateLock;
        synchronized (object) {
            candidates = this.mPeerCandidates.candidates(peer);
        }
        if (candidates.isEmpty()) {
            Log.w((String)TAG, (String)String.format("No ICE candidate gathered for peer: %s", peer));
        }
        this.unlockPeerOperation(Type.CANDIDATES, peer, description);
    }

    private void createConnection(String peer, boolean master) throws MediaEngineException {
        if (!this.createPeerConnection(peer, master)) {
            throw new MediaEngineException(String.format("Unable to create connection with Peer: %s", peer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private PendingPeerOperation createPeerOperation(@NonNull Type type, @NonNull String peer) throws MediaEngineException {
        PendingPeerOperation operation = new PendingPeerOperation(type, peer);
        Object object = mOperationLock;
        synchronized (object) {
            if (this.mPeerOperations.contains(operation)) {
                throw new MediaEngineException(String.format("An operation of type: %s is already pending for peer: %s", type.name(), peer));
            }
        }
        this.mPeerOperations.add(operation);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockPeerOperation(@NonNull Type type, @NonNull String peer, @Nullable SdpDescription value) {
        Log.d((String)TAG, (String)("unlockPeerOperation: " + (Object)((Object)type) + " " + peer + " " + value));
        Object object = mOperationLock;
        synchronized (object) {
            boolean isFound = false;
            for (PendingPeerOperation operation : this.mPeerOperations) {
                Log.d((String)TAG, (String)("unlockPeerOperation: " + operation + " :: valid value ? " + (null == value)));
                if (!operation.tryUnlock(type, peer, value)) continue;
                isFound = true;
                this.mPeerOperations.remove(operation);
                break;
            }
            if (!isFound) {
                Log.w((String)TAG, (String)String.format("No pending operation found for peer: %s with type: %s", peer, type.name()));
            }
        }
    }

    private void WaitForSdpMessage(@NonNull String peer, @NonNull Type type, @NonNull PendingPeerCallback listener) throws MediaEngineException {
        PendingPeerOperation descriptionOperation = this.createPeerOperation(type, peer);
        descriptionOperation.setListener(listener);
        descriptionOperation.waitOperation(DescriptionTimeout);
    }

    public static void setContext(@NonNull Context context) {
        MediaEngine.Context = context;
    }
}

