package voxeet.com.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class ConferenceUtils {

    private ConferenceUtils() {

    }



    @Nullable
    public static DefaultConferenceUser findUserById(@NonNull final String userId,
                                                     @Nullable List<DefaultConferenceUser> users) {
        if(null != users) {
            for (DefaultConferenceUser user : users) {
                if(null != user && userId.equalsIgnoreCase(user.getUserId())) {
                    return user;
                }
            }
        }
        return null;
    }

    @NonNull
    public static List<DefaultConferenceUser> findUsersMatching(@Nullable String currentUserOrEmpty, @Nullable List<DefaultConferenceUser> merged_list) {
        List<DefaultConferenceUser> list = new ArrayList<>();
        if(null != currentUserOrEmpty && null != merged_list) {
            for (DefaultConferenceUser user : merged_list) {
                if(null != user && currentUserOrEmpty.equalsIgnoreCase(user.getUserId())) {
                    list.add(user);
                }
            }
        }
        return list;
    }

    public static List<DefaultConferenceUser> getUserInState(List<DefaultConferenceUser> conferenceUsers, ConferenceUserStatus status) {
        List<DefaultConferenceUser> users = new ArrayList<>();
        for (DefaultConferenceUser user : conferenceUsers) {
            if(null != user && status.equals(user.getConferenceStatus())) {
                users.add(user);
            }
        }

        return users;
    }
}
