package voxeet.com.sdk.models.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.PSTNItem;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.abs.Conference;
import voxeet.com.sdk.models.abs.ConferenceUser;
import voxeet.com.sdk.utils.ConferenceUtils;

/**
 * Created by RomainB on 4/21/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultConference implements Conference {
    @JsonIgnore
    private String TAG = DefaultConference.class.getSimpleName();

    @JsonIgnore
    private boolean isOffline;

    @JsonIgnore
    private boolean isDemo = false;

    @JsonIgnore
    private boolean hasBeenCreated = false;

    @JsonIgnore
    private boolean isGuestAccess;

    @JsonIgnore
    private boolean isRecorded = false;

    @JsonIgnore
    private Date startRecordTimestamp;

    @JsonIgnore
    private String recordingUser;

    @JsonIgnore
    private RecordingStatus recordingStatus = RecordingStatus.NOT_RECORDING;

    @JsonProperty("conference")
    private DefaultConferenceInfos conferenceInfos;

    private String conferenceId;

    private String conferenceAlias;

    private String conferenceType;

    private String securityToken;

    private String meetingId;

    private String location;

    private String title;

    private String description;

    private DefaultUserProfile ownerProfile;

    private String pstnPinCode;

    private List<DefaultConferenceUser> conferenceUsers = new ArrayList<>();

    @JsonProperty("nodes")
    private List<PSTNItem> pstnItems;

    public DefaultConference() {

    }

    @JsonProperty("e164FallbackPhoneNumber")
    private String fallBackNumber;

    @Override
    public String getFallBackNumber() {
        return fallBackNumber;
    }

    public void setFallBackNumber(String fallBackNumber) {
        this.fallBackNumber = fallBackNumber;
    }

    @Override
    public DefaultConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    public List<PSTNItem> getPstnItems() {
        return pstnItems;
    }

    public void setPstnItems(List<PSTNItem> pstnItems) {
        this.pstnItems = pstnItems;
    }

    @Override
    public boolean hasBeenCreated() {
        return hasBeenCreated;
    }

    //TODO reminiscence from RealmObject isValid() - remove ?
    @Override
    public boolean isObjectValid() {
        return true;
    }

    public void setHasBeenCreated(boolean hasBeenCreated) {
        this.hasBeenCreated = hasBeenCreated;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    @Override
    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public DefaultUserProfile getOwnerProfile() {
        return ownerProfile;
    }

    public void setOwnerProfile(DefaultUserProfile ownerProfile) {
        this.ownerProfile = ownerProfile;
    }

    @Override
    public String getPstnPinCode() {
        return pstnPinCode;
    }

    public void setPstnPinCode(String pstnPinCode) {
        this.pstnPinCode = pstnPinCode;
    }

    @Override
    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    @Override
    public String getConferenceType() {
        return conferenceType;
    }

    public void setConferenceType(String conferenceType) {
        this.conferenceType = conferenceType;
    }

    @Override
    public String getSecurityToken() {
        return securityToken;
    }

    @NonNull
    @Override
    public List<DefaultConferenceUser> getConferenceUsers() {
        if (null != conferenceUsers) {
            return conferenceUsers;
        }
        return new ArrayList<>();
    }

    @Override
    public int getConferenceRoomSize() {
        if (conferenceUsers != null)
            return conferenceUsers.size();
        return 0;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setConferenceUsers(List<DefaultConferenceUser> conferenceUsers) {
        this.conferenceUsers = conferenceUsers;
    }

    @Override
    public boolean isOffline() {
        return isOffline;
    }

    public void setOffline(boolean offline) {
        isOffline = offline;
    }

    @Override
    public boolean isDemo() {
        return isDemo;
    }

    public void setDemo(boolean demo) {
        isDemo = demo;
    }

    @Override
    public boolean isGuestAccess() {
        return isGuestAccess;
    }

    public void setGuestAccess(boolean guestAccess) {
        isGuestAccess = guestAccess;
    }

    @Override
    public boolean isRecorded() {
        return isRecorded;
    }

    public void setRecorded(boolean recorded) {
        isRecorded = recorded;
    }

    @Override
    public Date getStartRecordTimestamp() {
        return startRecordTimestamp;
    }

    public void setStartRecordTimestamp(Date startRecordTimestamp) {
        this.startRecordTimestamp = startRecordTimestamp;
    }

    @Override
    public String getRecordingUser() {
        return recordingUser;
    }

    @Override
    public ConferenceUser getUserById(final String userId) {
        if (conferenceUsers != null) {
            return ConferenceUtils.findUserById(userId, conferenceUsers);
        }
        return null;
    }

    public void setRecordingUser(String recordingUser) {
        this.recordingUser = recordingUser;
    }

    @Override
    public boolean isConferenceEmpty() {
        if (conferenceUsers == null)
            return true;

        for (ConferenceUser user : conferenceUsers) {
            if (user.getConferenceStatus() == ConferenceUserStatus.ON_AIR)
                return false;
        }
        return true;
    }

    @Override
    public RecordingStatus getRecordingStatus() {
        return recordingStatus;
    }

    @Override
    public boolean isUsersOnAir() {
        if (conferenceUsers == null)
            return true;

        for (ConferenceUser user : conferenceUsers) {
            if (user.getConferenceStatus() == ConferenceUserStatus.ON_AIR)
                return true;
        }
        return false;
    }

    public void setRecordingStatus(RecordingStatus recordingStatus) {
        this.recordingStatus = recordingStatus;
    }

    public void setConferenceAlias(String conferenceAlias) {
        this.conferenceAlias = conferenceAlias;
    }

    public String getConferenceAlias() {
        return this.conferenceAlias;
    }


    /**
     * Transform any given participant to conference user
     * <p>
     * Get the DefaultConferenceUser or null
     *
     * @param participant the participant to map
     * @return true if the user has not been added
     */
    public boolean updateParticipantToConferenceUsers(@NonNull DefaultParticipant participant) {
        DefaultConferenceUser user = findUserById(participant.getParticipantId());
        boolean found = null != user;

        if (null == user) {
            user = new DefaultConferenceUser(participant.getParticipantId(),
                    participant.getDeviceType(),
                    new UserInfo(participant.getName(),
                            participant.getExternalId(),
                            participant.getAvatarUrl()));
            getConferenceUsers().add(user);
            found = false;
        } else {
            user.updateIfNeeded(participant.getName(),
                    participant.getAvatarUrl());
        }
        //TODO check for any user modification > name, avatarUrl

        ConferenceUserStatus status = ConferenceUserStatus.fromString(participant.getStatus());
        user.setConferenceStatus(status);

        return !found;
    }

    @Nullable
    public DefaultConferenceUser findUserById(@NonNull final String userId) {
        return ConferenceUtils.findUserById(userId, getConferenceUsers());
    }

}
