package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ExternalAuthStateEvent extends Event {

    private String timezone;

    @JsonProperty("push_token")
    private String pushToken;

    @JsonProperty("device_identifier")
    private String deviceIdentifier;

    @JsonProperty("device_type")
    private String deviceType;

    public ExternalAuthStateEvent(String pushToken, String deviceIdentifier, String timezone) {
        this.timezone = timezone;

        this.pushToken = pushToken;

        this.deviceIdentifier = deviceIdentifier;

        this.deviceType = "ANDROID";
    }

    public String getPushToken() {
        return pushToken;
    }

    public void setPushToken(String pushToken) {
        this.pushToken = pushToken;
    }

    public String getDeviceIdentifier() {
        return deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public String getType() {
        return EventNames.STATE_GENERATOR;
    }
}
