package voxeet.com.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.crypto.AbstractNativeMediaCryptoCallback;
import com.voxeet.android.media.stats.LocalStats;

import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.VideoSink;

import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;

/**
 * Created by kevinleperf on 17/10/2018.
 */

public class MediaService extends AbstractVoxeetService {

    private AbstractNativeMediaCryptoCallback mediaCryptoCallback;
    private MediaSDK media;

    public MediaService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    public boolean hasMedia() {
        return null != media;
    }

    public MediaSDK getMedia() {
        return media;
    }

    /**
     * @param peer
     * @return
     * @deprecated use {@link LocalStatsService#getLocalStats(String)}
     */
    @Deprecated
    @Nullable
    public LocalStats getLocalStats(@NonNull String peer) {
        if (null == peer) return null; //may happen in wrong implementation
        MediaSDK media = getMedia();
        if (null != media) return media.getLocalStats(peer);
        return null;
    }

    public void releaseMedia() {
        if (null != media) media.stop();

        media = null;
    }

    public void createMedia(Context context, String userId, MediaEngine.StreamListener mediaStreamListener,
                            CameraVideoCapturer.CameraEventsHandler cameraEventsHandler,
                            boolean videoOn, boolean useMic) throws MediaEngineException {
        media = new MediaSDK(context, userId, mediaStreamListener, cameraEventsHandler, videoOn, useMic, mediaCryptoCallback);
    }

    public EglBase.Context getEglContext() {
        if (null != media) {
            return media.getEglBase().getEglBaseContext();
        } else {
            return null;
        }
    }

    /**
     * Set a MediaCryptoCallback to be used "before" joining the conference
     * <p>
     * Note : it's not released automatically, it must be un/-set before any conference
     *
     * @param callback the callback to use, null to unset the callback
     */
    public void setCryptoCallback(@Nullable AbstractNativeMediaCryptoCallback callback) {
        this.mediaCryptoCallback = callback;
    }

    public boolean attachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        if (null != media) getMedia().attachMediaStream(videoSink, stream);
        return null != media;
    }

    public boolean unAttachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        if (null != media) getMedia().unattachMediaStream(videoSink, stream);
        return null != media;
    }
}
