package voxeet.com.sdk.core.http;

import android.support.annotation.NonNull;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.events.error.HttpException;

public class HttpHelper {
    private HttpHelper() {

    }


    public static <T> void enqueue(Call<T> call, @NonNull final HttpCallback<T> callback) {
        call.enqueue(new Callback<T>() {
            @Override
            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful() && null != response.body()) {
                    callback.onSuccess(response.body(), response);
                } else {
                    callback.onFailure(HttpException.throwResponse(response), response);
                }
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                callback.onFailure(t, null);
            }
        });
    }
}
