/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.error.UnsubscribeFromCallConferenceErrorEvent;
import voxeet.com.sdk.events.success.UnSubscribeFromConferenceAnswerEvent;

public class UnsubscribeForCallStartPromiseable
extends AbstractPromiseable<Boolean> {
    public UnsubscribeForCallStartPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ResponseBody> user = UnsubscribeForCallStartPromiseable.this.getProvider().getUnSubscribeFromCallObservable(UnsubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<Response<ResponseBody>>(){

                    @Override
                    public void onSuccess(@NonNull Response<ResponseBody> object, @NonNull Response<Response<ResponseBody>> response) {
                        UnsubscribeForCallStartPromiseable.this.log("You are no longer subscribed to this mConference's start");
                        UnsubscribeForCallStartPromiseable.this.getEventBus().post((Object)new UnSubscribeFromConferenceAnswerEvent(UnsubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId()));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<Response<ResponseBody>> response) {
                        HttpException.dumpErrorResponse(response);
                        UnsubscribeForCallStartPromiseable.this.log("Failed to unsubscribe from this mConference's start");
                        UnsubscribeForCallStartPromiseable.this.getEventBus().post((Object)new UnsubscribeFromCallConferenceErrorEvent(UnsubscribeForCallStartPromiseable.this.getInformation().getConference().getConferenceId(), UnsubscribeForCallStartPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

