/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.GetConferenceStatusErrorEvent;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class GetConferenceStatusPromiseable
extends AbstractPromiseable<GetConferenceStatusEvent> {
    public GetConferenceStatusPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<GetConferenceStatusEvent> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<GetConferenceStatusEvent>(){

            public void onCall(final @NonNull Solver<GetConferenceStatusEvent> solver) {
                Call<GetConferenceStatusEvent> user = GetConferenceStatusPromiseable.this.getProvider().getConferenceStatusObservable(GetConferenceStatusPromiseable.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<GetConferenceStatusEvent>(){

                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        try {
                            if (null != response && null != object.getConferenceUsers()) {
                                for (DefaultConferenceUser conferenceUser : object.getConferenceUsers()) {
                                    GetConferenceStatusPromiseable.this.log(conferenceUser.getUserId() + " / " + conferenceUser.getStatus());
                                }
                                GetConferenceStatusPromiseable.this.log("Dispatching mConference status result");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        GetConferenceStatusPromiseable.this.getEventBus().post((Object)object);
                        solver.resolve((Object)object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceStatusPromiseable.this.log("Error while getting mConference history");
                        e.printStackTrace();
                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(GetConferenceStatusPromiseable.this.getParent().handleError(e));
                            GetConferenceStatusPromiseable.this.getEventBus().post((Object)event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, e);
                        }
                        catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }
}

