/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.abs.AbstractPromiseable;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.http.HttpCallback;
import voxeet.com.sdk.core.http.HttpHelper;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.promises.PromiseDeclineConferenceResultEventException;
import voxeet.com.sdk.events.success.DeclineConferenceResultEvent;

public class DeclinePromise
extends AbstractPromiseable<DeclineConferenceResultEvent> {
    private static final String TAG = DeclinePromise.class.getSimpleName();
    private final String conferenceId;

    public DeclinePromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId) {
        super(parent, mediaService, provider, information, eventBus);
        this.conferenceId = conferenceId;
    }

    @Override
    @NonNull
    public Promise<DeclineConferenceResultEvent> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<DeclineConferenceResultEvent>(){

            public void onCall(final @NonNull Solver<DeclineConferenceResultEvent> solver) {
                Call<ResponseBody> user = DeclinePromise.this.getProvider().getDeclineObservable(DeclinePromise.this.conferenceId);
                HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)("IConference declined with id: " + DeclinePromise.this.conferenceId));
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(response.code() == 200);
                        DeclinePromise.this.getEventBus().post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable t, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        t.printStackTrace();
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(DeclinePromise.this.getParent().handleError(t), false);
                        DeclinePromise.this.getEventBus().post((Object)event);
                        solver.reject((Throwable)new PromiseDeclineConferenceResultEventException(event));
                    }
                });
            }
        });
    }
}

