/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.models.RecordingStatus;
import com.voxeet.sdk.models.abs.Conference;
import com.voxeet.sdk.models.abs.ConferenceUser;
import com.voxeet.sdk.models.impl.DefaultConferenceInfos;
import com.voxeet.sdk.models.impl.DefaultUserProfile;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="OwnUserInvitedEvent")
public class OwnUserInvited
extends Event {
    private String userId;
    @JsonProperty(value="conference")
    private DefaultConferenceInfos conferenceInfos;
    private List<DefaultUserProfile> guests;

    public List<DefaultUserProfile> getGuests() {
        return this.guests;
    }

    public void setGuests(List<DefaultUserProfile> guests) {
        this.guests = guests;
    }

    public Conference getConference() {
        Conference conference = new Conference();
        conference.setConferenceInfos(this.conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(this.conferenceInfos.getConferenceType());
        conference.setMeetingId(this.conferenceInfos.getMeetingId());
        conference.setConferenceId(this.conferenceInfos.getConferenceId());
        conference.setDescription(this.conferenceInfos.getDescription());
        conference.setLocation(this.conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
        for (DefaultUserProfile profile : this.guests) {
            conference.getConferenceUsers().add(new ConferenceUser(profile));
        }
        return conference;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DefaultConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return "OwnUserInvitedEvent";
    }
}

