/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.success.StopVideoAnswerEvent;
import com.voxeet.sdk.json.StopVideoResponse;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StopVideoPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = StopVideoPromise.class.getSimpleName();

    public StopVideoPromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    StopVideoPromise.this.log("stoppping video");
                    final ConferenceInformation information = StopVideoPromise.this.getInformation();
                    if (null == information || !StopVideoPromise.this.getParent().isInConference()) {
                        Log.d((String)TAG, (String)"stopVideo: not in conf");
                        if (StopVideoPromise.this.getMediaService().hasMedia()) {
                            StopVideoPromise.this.getMediaService().getMedia().stopVideo();
                        }
                        throw new NotInConferenceException();
                    }
                    String conferenceId = information.getConference().getConferenceId();
                    if (!StopVideoPromise.this.getMediaService().hasMedia()) {
                        Log.d((String)TAG, (String)"stopVideo: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    StopVideoPromise.this.getMediaService().getMedia().stopVideo();
                    Call<StopVideoResponse> stopVideo = StopVideoPromise.this.getProvider().getStopVideoObservable(conferenceId, VoxeetPreferences.id());
                    HttpHelper.enqueue(stopVideo, new HttpCallback<StopVideoResponse>(){

                        @Override
                        public void onSuccess(@NonNull StopVideoResponse object, @NonNull Response<StopVideoResponse> response) {
                            if (StopVideoPromise.this.getMediaService().hasMedia()) {
                                StopVideoPromise.this.getMediaService().getMedia().stopVideo();
                            }
                            information.setOwnVideoStarted(false);
                            StopVideoAnswerEvent event = new StopVideoAnswerEvent(true);
                            StopVideoPromise.this.getEventBus().post((Object)event);
                            StopVideoPromise.this.createVideoAnswer(object.getUserId(), object.getDescription(), object.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable t, @Nullable Response<StopVideoResponse> response) {
                            solver.reject(t);
                        }
                    });
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }
}

