/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.models.ConferenceUserStatus;
import com.voxeet.sdk.models.OfferCandidate;
import com.voxeet.sdk.models.OfferDescription;
import com.voxeet.sdk.models.abs.ConferenceUser;
import eu.codlab.simplepromise.Promise;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public abstract class AbstractPromiseable<PROMISE_RETURN_TYPE> {
    private final AbstractConferenceSdkObservableProvider provider;
    private final ConferenceInformation information;
    private final EventBus eventBus;
    @NonNull
    private MediaService mediaService;
    @NonNull
    private AbstractConferenceSdkService parent;

    protected AbstractPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        this.parent = parent;
        this.mediaService = mediaService;
        this.provider = provider;
        this.information = information;
        this.eventBus = eventBus;
    }

    @NonNull
    protected AbstractConferenceSdkService getParent() {
        return this.parent;
    }

    @NonNull
    protected MediaService getMediaService() {
        return this.mediaService;
    }

    @NonNull
    protected AbstractConferenceSdkObservableProvider getProvider() {
        return this.provider;
    }

    @Nullable
    protected ConferenceInformation getInformation() {
        if (null != this.information) {
            return this.information;
        }
        return this.parent.getCurrentConferenceInformation();
    }

    @NonNull
    protected EventBus getEventBus() {
        return this.eventBus;
    }

    protected boolean isInConference() {
        return this.getParent().isInConference();
    }

    protected boolean hasMedia() {
        return this.getMediaService().hasMedia();
    }

    @NonNull
    protected MediaSDK getMedia() {
        return this.getMediaService().getMedia();
    }

    @NonNull
    public abstract Promise<PROMISE_RETURN_TYPE> createPromise();

    protected void log(@NonNull String log) {
        if (!TextUtils.isEmpty((CharSequence)log)) {
            Log.d((String)this.getClass().getSimpleName(), (String)log);
        }
    }

    protected void setIsInConference(boolean status) {
        this.getParent().setIsInConference(status);
    }

    protected Promise<Boolean> createVideoAnswer(String userId, OfferDescription offerDescription, List<OfferCandidate> offerCandidates) {
        return this.getParent().createVideoAnswer(userId, offerDescription, offerCandidates);
    }

    protected boolean isSDK() {
        return this.getParent().isSDK();
    }

    protected ConferenceUser updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        return this.getParent().updateConferenceParticipants(userId, status);
    }

    protected void closeMedia() {
        this.getParent().closeMedia();
    }

    protected void removeTimeoutCallbacks() {
        this.getParent().removeTimeoutCallbacks();
    }

    protected void sendTimeoutCallbacks() {
        this.getParent().sendTimeoutCallbacks();
    }

    protected VoxeetSdkTemplate getVoxeetSDK() {
        return this.getParent().getVoxeetSDK();
    }

    @NonNull
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        return this.getParent().createOrSetConferenceWithParams(conferenceId, conferenceAlias);
    }

    protected ConferenceInformation getConferenceInformation(@Nullable String conferenceId) {
        return this.getParent().getConferenceInformation(conferenceId);
    }

    protected void joinLock() {
        this.getParent().joinLock();
    }

    protected void joinUnlock() {
        this.getParent().joinUnlock();
    }

    protected Promise<Boolean> joinConference(@NonNull ConferenceInformation conference) {
        return this.getParent().joinConferenceInternalPackage(conference);
    }

    protected void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        this.getParent().setCurrentConferenceIfNotInPreviousConference(conference);
    }
}

