package com.voxeet.sdk.models;

/**
 * Created by kevinleperf on 12/11/2017.
 */

public enum MeetingNotification {

    /**
     * The constant ALL_NOTIFICATION.
     */
    ALL_NOTIFICATION("ALL_NOTIFICATION"),
    /**
     * The constant NO_NOTIFICATION.
     */
    NO_NOTIFICATION("NONE_NOTIFICATION"),
    /**
     * The constant MENTION_NOTIFICATION.
     */
    MENTION_NOTIFICATION("MENTIONNED_NOTIFICATION");

    private String _name;

    private MeetingNotification() {

    }

    MeetingNotification(String name) {
        this();
        _name = name;
    }

    public String getName() {
        return _name;
    }

    public static MeetingNotification fromName(String name) {
        switch(name) {
            case "ALL_NOTIFICATION": return MeetingNotification.ALL_NOTIFICATION;
            case "NONE_NOTIFICATION": return MeetingNotification.NO_NOTIFICATION;
            case "MENTIONNED_NOTIFICATION": return MeetingNotification.MENTION_NOTIFICATION;
        }
        return null;
    }

}
