package com.voxeet.sdk.models;

public enum ConferenceType {
    STANDARD("STANDARD"),
    SCHEDULED("SCHEDULED"),
    DEMO("DEMO"),
    MEET_NOW("MEET_NOW"),
    REPLAY("REPLAY"),
    SDK_CONF("SDK_CONF"),
    USER_CONF("USER_CONF"),
    GUEST("GUEST");

    private final String value;

    ConferenceType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static ConferenceType fromId(String value) {
        switch (value) {
            case "STANDARD":
                return STANDARD;
            case "SCHEDULED":
                return SCHEDULED;
            case "DEMO":
                return DEMO;
            case "MEET_NOW":
                return MEET_NOW;
            case "REPLAY":
                return REPLAY;
            case "USER_CONF":
                return USER_CONF;
            case "SDK_CONF":
                return SDK_CONF;
            case "GUEST":
                return GUEST;
        }

        throw new IllegalArgumentException("No conference type with id[" + value + "]");
    }
}
