package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import com.voxeet.sdk.models.abs.Conference;
import com.voxeet.sdk.models.impl.DefaultInvitation;

@JsonIgnoreProperties(ignoreUnknown = true)
public class UniqueUrlResponse {

    private String userId;

    @JsonProperty("conference")
    private Conference conference;

    private List<DefaultInvitation> invitations;

    public List<DefaultInvitation> getInvitations() {
        return invitations;
    }

    public void setInvitations(List<DefaultInvitation> invitations) {
        this.invitations = invitations;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Conference getConference() {
        return conference;
    }

    public void setConference(Conference conference) {
        this.conference = conference;
    }
}
