package com.voxeet.sdk.events.success;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaStream;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.abs.Conference;
import com.voxeet.sdk.models.abs.ConferenceUser;

public class ConferenceUserUpdatedEvent extends SuccessEvent {

    private boolean isScreenShare;

    @NonNull
    private ConferenceUser user;

    @NonNull
    private String conferenceId;

    @Nullable
    private Conference conference;

    @Nullable
    private MediaStream mediaStream;

    public ConferenceUserUpdatedEvent(@NonNull ConferenceUser user,
                                      @NonNull String conferenceId,
                                      @Nullable Conference conference,
                                      @Nullable MediaStream mediaStream) {
        this(user, conferenceId, conference, mediaStream, false);
    }

    public ConferenceUserUpdatedEvent(@NonNull ConferenceUser user,
                                      @NonNull String conferenceId,
                                      @Nullable Conference conference,
                                      @Nullable MediaStream mediaStream,
                                      boolean isScreenShare) {
        this.isScreenShare = isScreenShare;
        this.user = user;
        this.conferenceId = conferenceId;
        this.conference = conference;
        this.mediaStream = mediaStream;
    }

    @Nullable
    public MediaStream getMediaStream() {
        return mediaStream;
    }

    public boolean isScreenShare() {
        return isScreenShare;
    }

    @NonNull
    public ConferenceUser getUser() {
        return user;
    }

    @NonNull
    public String getConferenceId() {
        return conferenceId;
    }

    @Nullable
    public Conference getConference() {
        return conference;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + " " + user + " " + mediaStream;
    }
}
