package com.voxeet.sdk.events.success;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaStream;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.abs.Conference;
import com.voxeet.sdk.models.abs.ConferenceUser;

/**
 * Created by RomainBenmansour on 4/18/16.
 */
public class ConferenceUserJoinedEvent extends SuccessEvent {

    @NonNull
    private ConferenceUser user;

    @Nullable
    private MediaStream mediaStream;

    @NonNull
    private String conferenceId;

    @Nullable
    private Conference conference;

    public ConferenceUserJoinedEvent(@NonNull ConferenceUser user,
                                     @NonNull String conferenceId,
                                     @Nullable Conference conference,
                                     @Nullable MediaStream mediaStream) {
        this.user = user;
        this.mediaStream = mediaStream;
        this.conferenceId = conferenceId;
        this.conference = conference;
    }

    public ConferenceUserJoinedEvent(@NonNull ConferenceUser user, @NonNull String conferenceId, @Nullable Conference conference) {
        this(user, conferenceId, conference, null);
    }

    @Nullable
    public MediaStream getMediaStream() {
        return mediaStream;
    }

    public void setMediaStream(@NonNull MediaStream mediaStream) {
        this.mediaStream = mediaStream;
    }

    @NonNull
    public String getConferenceId() {
        return conferenceId;
    }

    @Nullable
    public Conference getConference() {
        return conference;
    }

    @NonNull
    public ConferenceUser getUser() {
        return user;
    }

    public void setUser(@NonNull ConferenceUser user) {
        this.user = user;
    }
}
