package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import com.voxeet.sdk.core.ConferenceSimpleState;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.abs.information.ConferenceState;
import com.voxeet.sdk.core.abs.information.ConferenceUserType;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.success.ConferenceCreationSuccess;
import com.voxeet.sdk.events.success.ConferencePreJoinedEvent;
import com.voxeet.sdk.models.abs.Conference;

public class JoinPromise extends AbstractPromiseable<Boolean> {
    private final static String TAG = JoinPromise.class.getSimpleName();
    private final String conferenceId;
    private final ConferenceUserType userType;
    private final VoxeetSdkTemplate instance;

    public JoinPromise(@NonNull AbstractConferenceSdkService parent,
                       @NonNull MediaService mediaService,
                       @NonNull AbstractConferenceSdkObservableProvider provider,
                       @Nullable ConferenceInformation information,
                       @NonNull EventBus eventBus,
                       @NonNull VoxeetSdkTemplate instance,
                       @NonNull String conferenceId,
                       @NonNull ConferenceUserType userType) {
        super(parent, mediaService, provider, information, eventBus);

        this.instance = instance;
        this.conferenceId = conferenceId;
        this.userType = userType;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        final Promise<Boolean> promise = new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                //locking
                joinLock();

                //init the conference with the proper conferenceId and alias to null
                ConferenceInformation information = createOrSetConferenceWithParams(conferenceId, null);
                information.setConferenceUserType(userType);

                String currentConferenceId = getParent().getConferenceId();
                ConferenceInformation holder = getConferenceInformation(conferenceId);

                boolean init_done = null != holder &&
                        (ConferenceState.JOINING.equals(holder.getConferenceState())
                                || ConferenceState.JOINED.equals(holder.getConferenceState()));

                if (null != currentConferenceId && currentConferenceId.equals(conferenceId) && init_done) {
                    Log.d(TAG, "onCall: join the conference " + conferenceId + " // invalid call ! already calling it");
                    Log.d(TAG, "onCall: btw, the current " + conferenceId + " state is := " + holder.getConferenceState());

                    solver.resolve(true);
                    joinUnlock();
                    return;
                }

                //prevent issue with the join
                setIsInConference(true);

                Conference conference = holder.getConference();

                Log.d(TAG, "Attempting to join conference alias:=" + conference.getConferenceAlias() + " conferenceId:=" + conferenceId);

                Log.d(TAG, "onNext: having conference");

                getEventBus().post(new ConferencePreJoinedEvent(conferenceId, conference.getConferenceAlias()));

                information.setConferenceState(ConferenceState.JOINING);
                information.setConferenceType(ConferenceSimpleState.CONFERENCE);

                Log.d(TAG, "onNext: join with := " + conference.getConferenceId() + " " + conference.getConferenceAlias());

                joinUnlock();

                //fromthe onConferenceCreated deprecated method
                //createOrSetConferenceWithParams(conferenceId, conferenceAlias);
                //getConferenceInformation(conferenceId).setConferenceState(ConferenceState.CREATED);

                //getTwig().i("IConference created with id: " + mConferenceId);

                //mEventBus.post(new ConferenceCreationSuccess(conferenceId, conferenceAlias));
                getEventBus().post(new ConferenceCreationSuccess(conferenceId, conference.getConferenceAlias()));

                //set the current conference if none is set in the SDK
                setCurrentConferenceIfNotInPreviousConference(information);

                //try to join the conference
                joinConference(information).then(new PromiseExec<Boolean, Object>() {
                    @Override
                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve(result);
                    }
                }).error(new ErrorPromise() {
                    @Override
                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve(false);
                    }
                });
                //solver.resolve(onConferenceCreated(conference.getConferenceAlias(), conference.getConferenceAlias(), null));


            }
        });

        if (instance.isSocketOpen()) {
            return promise;
        } else {
            return new Promise<Boolean>(new PromiseSolver<Boolean>() {
                @Override
                public void onCall(@NonNull final Solver<Boolean> solver) {
                    Log.d(TAG, "onCall: joining but the socket is disconnected");
                    instance.logCurrentlySelectedUserWithChain().then(new PromiseExec<Boolean, Object>() {
                        @Override
                        public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                            Log.d(TAG, "onCall: connection ? " + result);
                            promise.then(new PromiseExec<Boolean, Object>() {
                                @Override
                                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                    Log.d(TAG, "onCall: join ok? " + result);
                                    solver.resolve(result);
                                }
                            }).error(new ErrorPromise() {
                                @Override
                                public void onError(@NonNull Throwable error) {
                                    Log.d(TAG, "onError: join ko");
                                    solver.reject(error);
                                }
                            });
                        }
                    }).error(new ErrorPromise() {
                        @Override
                        public void onError(@NonNull Throwable error) {
                            solver.reject(error);
                        }
                    });
                }
            });
        }
    }
}
