/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.events.ConferenceTimeoutUserJoinedEvent;
import com.voxeet.sdk.utils.Twig;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;

public class TimeoutRunnable
implements Runnable {
    private static final String TAG = TimeoutRunnable.class.getSimpleName();
    private long mTimeout;
    @NonNull
    private EventBus mEventBus;
    @NonNull
    private Twig mLogger;
    @NonNull
    private AbstractConferenceSdkService mService;
    private boolean mCanceled;
    private boolean mTriggered;

    private TimeoutRunnable() {
        this.setCanceled(false);
        this.mTriggered = false;
    }

    public TimeoutRunnable(@NonNull AbstractConferenceSdkService service, @NonNull Twig logger, @NonNull EventBus event_bus, long timeout) {
        this();
        this.mService = service;
        this.mLogger = logger;
        this.mEventBus = event_bus;
        this.mTimeout = timeout;
    }

    public void setCanceled(boolean canceled) {
        this.mCanceled = canceled;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    @Override
    public void run() {
        if (!this.isCanceled()) {
            this.mLogger.i("No conference user joined after " + this.mTimeout + "ms. Now Attempting to leave the conference", new Object[0]);
            this.mService.leave().then(new PromiseExec(){

                public void onCall(@Nullable Object o, @NonNull Solver solver) {
                }
            }).error(new ErrorPromise(){

                public void onError(Throwable error) {
                    error.printStackTrace();
                }
            });
            this.mEventBus.post((Object)new ConferenceTimeoutUserJoinedEvent(this.mTimeout));
            this.mTriggered = true;
        }
    }

    public boolean isTriggered() {
        return this.mTriggered;
    }
}

