package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import com.voxeet.sdk.models.InvitedContact;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_EXTERNAL_INVITATION)
public class OwnExternalInvitationSentEvent extends Event {

    private String userId;

    @JsonProperty("externalRequestedEvents")
    private List<InvitedContact> contacts;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<InvitedContact> getContacts() {
        return contacts;
    }

    public void setContacts(List<InvitedContact> contacts) {
        this.contacts = contacts;
    }

    @Override
    public String getType() {
        return EventNames.OWN_EXTERNAL_INVITATION;
    }
}
