package com.voxeet.android.media.camera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.video.Camera2Enumerator;

import org.webrtc.Camera1Enumerator;

public class CameraEnumeratorPreLollipopWrapper implements CameraEnumeratorWrapper {


    private String frontName;
    private String backName;
    private String defaultCamera;
    private Camera1Enumerator enumerator;
    private Context context;

    public CameraEnumeratorPreLollipopWrapper(@NonNull Context context) {

        enumerator = new Camera1Enumerator(false);

        String[] names = enumerator.getDeviceNames();
        if (null != names && names.length > 0) {
            for (String name : names) {
                if (enumerator.isFrontFacing(name)) {
                    frontName = defaultCamera;
                    defaultCamera = name;
                } else if(enumerator.isBackFacing(name)) {
                    backName = name;
                }
            }
        }

        if(null == defaultCamera) {
            defaultCamera = backName;
        }
    }

    @Nullable
    @Override
    public String getDefaultName() {
        return defaultCamera;
    }

    @Override
    public void setDefaultName(@NonNull String defaultName) {
        if(null != defaultName) {
            if(defaultName.equals(frontName)) this.defaultCamera = frontName;
            if(defaultName.equals(backName)) this.defaultCamera = backName;
        }
    }

    @Nullable
    @Override
    public String getNameOfFrontCamera() {
        return frontName;
    }

    @Nullable
    @Override
    public String getNameOfBackCamera() {
        return backName;
    }

    @Override
    public boolean isFrontFacing(@Nullable String deviceName) {
        if(null != deviceName) {
            return deviceName.equals(getNameOfFrontCamera());
        }
        return false;
    }
}
