/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.abs;

import android.support.annotation.NonNull;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.ConferenceQuality;
import com.voxeet.sdk.models.ConferenceUserStatus;
import com.voxeet.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConferenceUser {
    private String TAG = ConferenceUser.class.getSimpleName();
    @JsonIgnore
    private boolean isMuted = false;
    @JsonIgnore
    private UserInfo userInfo;
    @JsonProperty(value="user_id")
    private String userId;
    private String quality;
    @JsonIgnore
    private String deviceType;
    @JsonIgnore
    private String status;
    @JsonIgnore
    private ConferenceUserStatus conferenceStatus;
    private String conferenceStatusToString;
    private boolean isOwner;
    @JsonIgnore
    private DefaultUserProfile profile;
    private boolean isRecordingOwner = false;
    private boolean isWhispering = false;

    public ConferenceUser() {
        this.userInfo = null;
    }

    public ConferenceUser(String userId, String device) {
        this.userId = userId;
        this.deviceType = device;
        this.conferenceStatus = ConferenceUserStatus.ON_AIR;
        this.userInfo = null;
        this.isMuted = false;
        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    public ConferenceUser(String userId, String device, UserInfo userInfo) {
        this.userId = userId;
        this.deviceType = device;
        this.profile = new DefaultUserProfile();
        this.profile.setUserId(userId);
        this.profile.setPhotoId(userInfo.getAvatarUrl());
        this.profile.setFirstName(userInfo.getName());
        this.profile.setLastName(userInfo.getName());
        this.profile.setNickName(userInfo.getName());
        this.setWhispering(false);
        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
        this.userInfo = userInfo;
        this.isMuted = false;
    }

    public ConferenceUser(DefaultUserProfile profile) {
        this.profile = profile;
        this.userId = profile.getUserId();
        this.setConferenceStatus(ConferenceUserStatus.IN_PROGRESS);
        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    public boolean isRecordingOwner() {
        return this.isRecordingOwner;
    }

    public boolean isWhispering() {
        return this.isWhispering;
    }

    public void setOwner(boolean owner) {
        this.isOwner = owner;
    }

    public void setRecordingOwner(boolean recordingOwner) {
        this.isRecordingOwner = recordingOwner;
    }

    public void setWhispering(boolean whispering) {
        this.isWhispering = whispering;
    }

    public void setIsRecordingOwner(boolean isRecordingOwner) {
        this.isRecordingOwner = isRecordingOwner;
    }

    public ConferenceUserStatus getConferenceStatus() {
        if (this.conferenceStatus == null && this.conferenceStatusToString != null) {
            return ConferenceUserStatus.valueOf((String)this.conferenceStatusToString);
        }
        return this.conferenceStatus;
    }

    public ConferenceUser setConferenceStatus(@NonNull ConferenceUserStatus conferenceStatus) {
        this.conferenceStatus = conferenceStatus;
        this.conferenceStatusToString = conferenceStatus.toString();
        return this;
    }

    public DefaultUserProfile getProfile() {
        return this.profile;
    }

    public void setProfile(DefaultUserProfile profile) {
        this.profile = profile;
    }

    @Deprecated
    public String getStatus() {
        return this.getConferenceStatusToString();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public void setMuted(boolean muted) {
        this.isMuted = muted;
    }

    public String getConferenceStatusToString() {
        return this.conferenceStatusToString;
    }

    public void setConferenceStatusToString(String conferenceStatusToString) {
        this.conferenceStatusToString = conferenceStatusToString;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    public ConferenceUser setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    public String toString() {
        return "DefaultConferenceUser{userInfo=" + this.userInfo + ", userId='" + this.userId + '\'' + '}';
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof ConferenceUser) {
            ConferenceUser user = (ConferenceUser)obj;
            return null != user.getUserId() && user.getUserId().equals(this.getUserId());
        }
        return super.equals(obj);
    }

    public void updateIfNeeded(String name, String avatarUrl) {
        if (null == this.userInfo) {
            this.userInfo = new UserInfo();
        }
        this.userInfo.setName(name);
        this.userInfo.setAvatarUrl(avatarUrl);
    }
}

