package com.voxeet.sdk.core;

import android.support.annotation.NonNull;

import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.utils.Validate;

public class VoxeetSdkFactory {

    private VoxeetSdkFactory() {
        super();
    }

    /**
     * This function validate the SDK Instance and init its behaviour.
     *
     * @param sdk_template The SDK Instance to validate
     */
    protected static synchronized void validate(@NonNull VoxeetSdkTemplate sdk_template) {
        Validate.hasInternetPermissions(sdk_template.getApplicationContext(), true);
        VoxeetPreferences.init(sdk_template.getApplicationContext(),
                sdk_template.getVoxeetEnvironmentHolder());
    }
}
