/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.SubscribeConferenceErrorEvent;
import com.voxeet.sdk.events.success.SubscribeConferenceEvent;
import com.voxeet.sdk.models.SubscribeConference;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class SubscribeConferenceEventPromiseable
extends AbstractPromiseable<Boolean> {
    public SubscribeConferenceEventPromiseable(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<SubscribeConference> user = SubscribeConferenceEventPromiseable.this.getProvider().getSubscribeObservable(SubscribeConferenceEventPromiseable.this.getInformation().getConference().getConferenceId());
                HttpHelper.enqueue(user, new HttpCallback<SubscribeConference>(){

                    @Override
                    public void onSuccess(@NonNull SubscribeConference object, @NonNull Response<SubscribeConference> response) {
                        SubscribeConferenceEventPromiseable.this.log("You are no subscribed to this mConference's events");
                        SubscribeConferenceEventPromiseable.this.getEventBus().post((Object)new SubscribeConferenceEvent(object));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<SubscribeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        SubscribeConferenceEventPromiseable.this.log("Failed to subscribe to this mConference's events");
                        SubscribeConferenceEventPromiseable.this.getEventBus().post((Object)new SubscribeConferenceErrorEvent(SubscribeConferenceEventPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

