/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.abs.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.core.abs.AbstractPromiseable;
import com.voxeet.sdk.core.abs.information.ConferenceInformation;
import com.voxeet.sdk.core.http.HttpCallback;
import com.voxeet.sdk.core.http.HttpHelper;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.PromiseDeclineConferenceResultEventException;
import com.voxeet.sdk.events.success.DeclineConferenceResultEvent;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class DeclinePromise
extends AbstractPromiseable<DeclineConferenceResultEvent> {
    private static final String TAG = DeclinePromise.class.getSimpleName();
    private final String conferenceId;

    public DeclinePromise(@NonNull AbstractConferenceSdkService parent, @NonNull MediaService mediaService, @NonNull AbstractConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId) {
        super(parent, mediaService, provider, information, eventBus);
        this.conferenceId = conferenceId;
    }

    @Override
    @NonNull
    public Promise<DeclineConferenceResultEvent> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<DeclineConferenceResultEvent>(){

            public void onCall(final @NonNull Solver<DeclineConferenceResultEvent> solver) {
                Call<ResponseBody> user = DeclinePromise.this.getProvider().getDeclineObservable(DeclinePromise.this.conferenceId);
                HttpHelper.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)("IConference declined with id: " + DeclinePromise.this.conferenceId));
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(response.code() == 200);
                        DeclinePromise.this.getEventBus().post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable t, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        t.printStackTrace();
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(DeclinePromise.this.getParent().handleError(t), false);
                        DeclinePromise.this.getEventBus().post((Object)event);
                        solver.reject((Throwable)new PromiseDeclineConferenceResultEventException(event));
                    }
                });
            }
        });
    }
}

