package com.voxeet.sdk.models;

/**
 * Created by Thomas on 15/12/2015.
 */
public enum NotificationType {
    ALL("ALL"),
    MENTIONED("MENTIONED"),
    NONE("NONE");

    private final String value;

    NotificationType(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static NotificationType fromId(String value) {
        switch (value) {
            case "ALL" : return ALL;
            case "MENTIONED" : return MENTIONED;
            case "NONE" : return NONE;
            default: return ALL;
        }
    }
}
