package com.voxeet.sdk.json.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.HashMap;

/**
 * Created by kevinleperf on 19/04/2018.
 */

public class MetadataHolder {

    private HashMap<String, Object> values;

    public MetadataHolder() {
        values = new HashMap<>();

        setStats(false).isLiveRecording(false);
    }

    public MetadataHolder(HashMap<String, Object> values) {
        this.values = values;
    }

    public MetadataHolder setStats(boolean stats) {
        return putValue("stats", stats);
    }

    public MetadataHolder isLiveRecording(boolean liveRecording) {
        return putValue("liveRecording", liveRecording);
    }

    public MetadataHolder putValue(@NonNull String key, @Nullable Object value) {
        values.put(key, value);
        return this;
    }

    public HashMap<String, Object> build() {
        return values;
    }
}
