package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import com.voxeet.sdk.core.preferences.VoxeetPreferences;

/**
 * Created by Thomas on 20/10/2015.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_STARTED)
public class FilePresentationStarted extends Event {

    private String conferenceId;

    private String userId;

    private int imageCount;

    private String fileId;

    private int position;

    public FilePresentationStarted() {

    }

    public FilePresentationStarted(String conferenceId,
                                   String userId,
                                   int imageCount,
                                   String fileId,
                                   int position) {
        this();

        setConferenceId(conferenceId)
                .setUserId(userId)
                .setImageCount(imageCount)
                .setFileId(fileId)
                .setPosition(position);
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public FilePresentationStarted setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
        return this;
    }

    public String getFileId() {
        return fileId;
    }

    public FilePresentationStarted setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String setUserId() {
        return userId;
    }

    public FilePresentationStarted setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public int getPosition() {
        return position;
    }

    public FilePresentationStarted setPosition(int position) {
        this.position = position;
        return this;
    }

    public int getImageCount() {
        return imageCount;
    }

    public FilePresentationStarted setImageCount(int imageCount) {
        this.imageCount = imageCount;
        return this;
    }

    public boolean isOwner() {
        return null != userId && userId.equals(VoxeetPreferences.id());
    }

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_STARTED;
    }
}
