package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeName(EventNames.CONFERENCE_MESSAGE_RECEIVED)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConferenceMessageReceived extends Event {

    @JsonProperty("user_id")
    private String userId;

    @JsonProperty("conference_id")
    private String conferenceId;

    private String message;

    private String externalId;

    @JsonProperty("message_type")
    private String messageType;

    public ConferenceMessageReceived() { }

    public ConferenceMessageReceived(String userId, String conferenceId, String message, String externalId, String messageType) {
        this.userId = userId;
        this.conferenceId = conferenceId;
        this.message = message;
        this.externalId = externalId;
        this.messageType = messageType;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getType() {
        return EventNames.CONFERENCE_MESSAGE_RECEIVED;
    }
}
