package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;
import com.voxeet.sdk.core.abs.AbstractConferenceSdkService;
import com.voxeet.sdk.events.ConferenceTimeoutUserJoinedEvent;
import com.voxeet.sdk.utils.Twig;

/**
 *
 */

public class TimeoutRunnable implements Runnable {

    private static final String TAG = TimeoutRunnable.class.getSimpleName();

    private long mTimeout;
    private @NonNull
    EventBus mEventBus; //initialized with parametered-constructor
    private @NonNull
    Twig mLogger; //initialized with parametered-constructor
    private @NonNull
    AbstractConferenceSdkService mService; //initialized with parametered-constructor
    private boolean mCanceled;
    private boolean mTriggered;

    /**
     * Default constructor, make the runnable "not canceled" by default
     * and triggered is false
     */
    private TimeoutRunnable() {
        setCanceled(false);
        mTriggered = false;
    }

    /**
     * @param service   the service which will be called back
     * @param logger    a logger to send the few logs this class will manage
     * @param event_bus the configured event bus
     * @param timeout   the current timeout
     */
    public TimeoutRunnable(@NonNull AbstractConferenceSdkService service,
                           @NonNull Twig logger,
                           @NonNull EventBus event_bus,
                           long timeout) {
        this();

        mService = service;
        mLogger = logger;
        mEventBus = event_bus;
        mTimeout = timeout;
    }

    public void setCanceled(boolean canceled) {
        mCanceled = canceled;
    }

    public boolean isCanceled() {
        return mCanceled;
    }

    @Override
    public void run() {

        if (!isCanceled()) {
            mLogger.i("No conference user joined after " + mTimeout
                    + "ms. Now Attempting to leave the conference");

            mService.leave()
                    .then(new PromiseExec() {
                        @Override
                        public void onCall(@Nullable Object o, @NonNull Solver solver) {

                        }
                    })
                    .error(new ErrorPromise() {
                        @Override
                        public void onError(Throwable error) {
                            error.printStackTrace();
                        }
                    });

            //conference was left after Xms
            //note that if you change the timeout after calling the join, the
            //value returned is absolutely inaccurate
            mEventBus.post(new ConferenceTimeoutUserJoinedEvent(mTimeout));
            mTriggered = true;
        }
    }

    public boolean isTriggered() {
        return mTriggered;
    }
}
