package com.voxeet.sdk.core.abs;

import com.voxeet.android.media.peer.SdpDescription;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;
import com.voxeet.sdk.events.success.GetConferenceStatusEvent;
import com.voxeet.sdk.events.success.ReplayConferenceEvent;
import com.voxeet.sdk.events.success.ResumeConference;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.models.CandidatesPush;
import com.voxeet.sdk.models.ConferenceResponse;
import com.voxeet.sdk.models.HistoryConference;
import com.voxeet.sdk.models.SubscribeConference;

/**
 * Created by kevinleperf on 13/11/2017.
 */

public abstract class AbstractConferenceSdkObservableProvider<T> {

    protected abstract T getService();

    public abstract void setRetrofitInstantiatedProvider(T service);

    public abstract Class getRetrofitInjectedClass();

    public abstract Call<ResponseBody> leaveConference(String conferenceId);

    public abstract Call<ResponseBody> getDeclineObservable(String conferenceId);

    public abstract Call<StartVideoResponse> getStartVideoObservable(String conferenceId, String id);

    public abstract Call<StopVideoResponse> getStopVideoObservable(String conferenceId, String id);

    public abstract Call<StartScreenSharingResponse> getStartScreenShareObservable(String conferenceId, String id);

    public abstract Call<StopScreenSharingResponse> getStopScreenShareObservable(String conferenceId, String id);

    public abstract Call<ConferenceResponse> getCreateConferenceObservable(CreateConferenceParams params);

    public abstract Call<ConferenceResponse> getCreateDemoObservable();

    public abstract Call<ResponseBody> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation);

    public abstract Call<ReplayConferenceEvent> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody);

    public abstract Call<ResponseBody> getStartRecordingObservable(String conferenceId);

    public abstract Call<ResponseBody> getStopRecordingObservable(String conferenceId);

    public abstract Call<ResponseBody> getLogOutObservable(String token);

    public abstract Call<GetConferenceStatusEvent> getConferenceStatusObservable(String conferenceId);

    public abstract Call<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId);

    public abstract Call<SubscribeConference> getSubscribeObservable(String conferenceId);

    public abstract Call<ResponseBody> getUnSubscribeObservable(String conferenceId);

    public abstract Call<ResponseBody> getSubscribeForCallObservable(String conferenceId);

    public abstract Call<ResponseBody> getUnSubscribeFromCallObservable(String conferenceId);

    public abstract Call<ResumeConference> joinConference(String conferenceId, JoinParameters deviceEvent);

    public abstract Call<ResponseBody> answerConference(String conferenceId, String peer, SdpDescription description);

    public abstract Call<ResponseBody> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent);

    public abstract Call<ResponseBody> candidates(String conferenceId, String peerId, CandidatesPush candidates);

    public abstract Call<ResponseBody> renegociate(String conferenceId);

    public abstract Call<ResponseBody> iceRestart(String conferenceId);
}
